<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<?php /* If this is the home page */ if (is_home()) { ?>
<title><?php bloginfo('name'); ?> &raquo; <?php bloginfo('description'); ?></title>
<?php /* If this is a single page */ } elseif (is_single()) { ?>
<title><?php wp_title(''); ?> bei <?php bloginfo('name'); ?></title>
<?php /* If this is a page */ } elseif (is_page()) { ?>
<title><?php bloginfo('name'); ?> &raquo; <?php bloginfo('description'); ?></title>
<?php /* If this is a category archive */ } elseif (is_category()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Kategorie <?php single_cat_title(''); ?></title>
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Archiv vom <?php the_time('j. F Y'); ?></title>
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Archiv vom <?php the_time('F Y'); ?></title>
<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<title><?php wp_title(''); ?> &raquo; Archiv vom Jahr <?php the_time('Y'); ?></title>
<?php /* more links to find */ } elseif (is_search()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Suche nach "<?php the_search_query(); ?>"</title>
<?php /* more posts with tag to find */ } elseif (is_tag()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Tag &raquo; <?php if (function_exists('is_tag') and is_tag()) { echo $tag; } ?></title>
<?php /* If this is a 404 page */} elseif (is_404()) { ?>
<title><?php bloginfo('name'); ?> &raquo; Sorry, nichts gefunden.</title>
<?php /* If this is not a specified archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
<title><?php bloginfo('name'); ?> &raquo; <?php bloginfo('description'); ?></title>
<?php } ?>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="robots" content="index,follow" />
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="content-language" content="de" />
<meta name="Author" content="<?php bloginfo('name'); ?>" />
<meta name="Publisher" content="<?php bloginfo('name'); ?>" />
<meta name="Copyright" content="<?php bloginfo('name'); ?>" />
<meta name="Page-topic" content="<?php bloginfo('description'); ?>" />
<meta name="Audience" content="Alle" />
<meta name="Description" content="Informationen und Links zu Webdesign, Webprogrammierung, Webanwendungen, freie Entwicklungs- und Internetwerkzeuge" />
<meta name="Generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->

<link rel="shortcut icon" href="/favicon.ico" />
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_head(); ?>

</head>
<body>

<div id="navHead">
	<ul>
		<li class="page_item<?php if(is_home()){echo ' current_page_item';}?>"><a href="<?php echo get_settings('home'); ?>" title="Startseite" accesskey="H">Home</a></li>
		<?php wp_list_pages('sort_column=menu_order&title_li='); ?>
		<li class="rssComm"><a href="<?php bloginfo('comments_rss2_url'); ?>">RSS Kommentare</a></li>
		<li class="rssEntr"><a href="<?php bloginfo('rss2_url'); ?>">RSS Beitr&auml;ge</a></li>
	</ul>
</div>

<div id="head">

	<h1><a href="<?php echo get_settings('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
	<p><?php bloginfo('description'); ?></p>
</div>
