<?php
/*
Template Name: Contact
*/
$cp_question = "2 + 3 = ?";
$cp_answer = "5";
?>
<?php get_header(); ?>

<div id="centerTL">
<div id="centerTR">
<div id="centerBR">
<div id="centerBL">
	<div id="container">
		<div id="left">

	    <div id="comments-form">

			<?php while (have_posts()) : the_post(); ?>
				<?php
					//validate email adress
					function is_valid_email($email)
					{
  						return (eregi ("^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}$", $email));
					}
					function is_valid_user($answer)
					{
						global $cp_answer;
						if ($answer == $cp_answer) { return true; } else { return false;}
					}
					//clean up text
					function clean($text)
					{
						return stripslashes($text);
					}
					//encode special chars (in name and subject)
					function encodeMailHeader ($string, $charset = 'UTF-8')
					{
    					return sprintf ('=?%s?B?%s?=', strtoupper ($charset),base64_encode ($string));
					}

					$cp_name    = (!empty($_POST['cp_name']))    ? $_POST['cp_name']    : "";
					$cp_email   = (!empty($_POST['cp_email']))   ? $_POST['cp_email']   : "";
					$cp_url     = (!empty($_POST['cp_url']))     ? $_POST['cp_url']     : "";
					$cp_ans     = (!empty($_POST['cp_ans']))     ? $_POST['cp_ans']     : "";
					$cp_message = (!empty($_POST['cp_message'])) ? $_POST['cp_message'] : "";
					$cp_message = clean($cp_message);
					$error_msg = "";
					$send = 0;
					if (!empty($_POST['sub'])) {			
						$send = 1;
						if (empty($cp_name) || empty($cp_email) || empty($cp_message) || empty($cp_ans)) {
							$error_msg.= "<p class=\"errmsg\">Bitte alle erforderlichen Felder ausf&uuml;llen.</p>\n";
							$send = 0;							
						}						
						if (!is_valid_email($cp_email)) {
							$error_msg.= "<p class=\"errmsg\">Ihre E-Mail Adresse ist ung&uuml;ltig.</p>\n";
							$send = 0;
						}	
						if (!is_valid_user($cp_ans)) {
							$error_msg.= "<p class=\"errmsg\">Falsche Antwort zur AntiSpam Frage.</p>\n";
							$send = 0;
						}									
					}
					if (!$send) { ?>
	
	        <h2 class="h3comm" style="margin-top:5px;">Nachricht senden</h2>

					<?php echo $error_msg;?>

						<form id="commentform" method="post" action="<?php echo "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">
              
						<p class="skinned">
						<label for="cp_name">Name (erforderlich):</label>
						<input type="text" name="cp_name" id="cp_name" value="<?php echo $cp_name ;?>" />
						</p>
		
						<p class="skinned">
						<label for="cp_email">E-Mail (erforderlich):</label>
						<input type="text" name="cp_email" id="cp_email" value="<?php echo $cp_email ;?>" size="" />
						</p>
		
						<p class="skinned">
						<label for="cp_url">Homepage:</label>
						<input type="text" name="cp_url" id="cp_url" value="<?php echo $cp_url; ?>" size="" />
						</p>
		
						<p class="skinned">
						<label for="cp_ans">Resultat (erforderlich): <?php echo $cp_question; ?> [F&uuml;r AntiSpam Pr&uuml;fung]</label>
						<input type="text" name="cp_ans" id="cp_ans" value="<?php echo $cp_ans; ?>" size="" />
						</p>
		
						<p class="skinnedArea">
						<label for="cp_message">Nachricht (erforderlich):</label>

						<textarea name="cp_message" id="cp_message" rows="" cols=""><?php echo $cp_message ;?></textarea>
						</p>

						<input type="submit" id="sub" name="sub" value="Senden" />		

						</form>

					<?php

					} else {
						$displayName_array	= explode(" ",$cp_name);
						$displayName = htmlentities(utf8_decode($displayName_array[0]));
			
						$header  = "MIME-Version: 1.0\n";
						$header .= "Content-Type: text/plain; charset=\"utf-8\"\n";
						$header .= "From:" . encodeMailHeader($cp_name) . "<" . $cp_email . ">\n";
						$email_subject	= "[" . get_settings('blogname') . "] " . encodeMailHeader($cp_name);
						$email_text		= "From......: " . $cp_name . "\n" .
							  "Email.....: " . $cp_email . "\n" .
							  "Url...........: " . $cp_url . "\n\n" .
							  $cp_message;

						if (@mail(get_settings('admin_email'), $email_subject, $email_text, $header)) {
							echo "<h3 class='h3comm' style='margin-top:5px;'>Vielen Dank f&uuml;r Ihre Nachricht!</h3><h4 style='color:#ffffff; margin:0 0 10px 40px; float:left;'>Ich werde so schnell wie m&ouml;glich Ihre E-Mail beantworten.</h4>";
						}
					}
					?>
				<?php endwhile; ?>

				</div>

			</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
