<?php get_header(); ?>

	<div id="content" class="narrowcolumn">

	<?php if (have_posts()) : ?>
		
		<?php while (have_posts()) : the_post(); ?>
				
			<div class="postwrapper" id="post-<?php the_ID(); ?>">
			  <div class="title">
				<small><?php the_time('j.m.Y') ?></small>
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink zu <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			  </div>
			  <div class="post">
			    <div class="entry">
			      <?php the_content('<!-- Read More -->'); ?>
				  <ul class="buttons">
				   <li><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink zu <?php the_title(); ?>">Weiterlesen &raquo;</a></li>
				    <li><?php edit_post_link('Edit Post'); ?></li>
				  </ul>
		        </div>
			    <div class="postinfo">
			      <p>Geschrieben von: <strong><?php the_author() ?></strong><br />
                  <?php comments_popup_link('Bisher keine Kommentare...', '1 Kommentar bis jetzt...', 'Schon % Kommentare...'); ?></p>
				  <p>Kategorien:</p>
				  	<ul class="catlist onecol">
                      <li><?php the_category('</li><li>') ?></li>
	                </ul>
			    </div>
			  </div>
			</div>
	
		<?php endwhile; ?>
		
	<?php else : ?>

		<div class="title">
		  <h2>Nicht gefunden</h2>
		</div>
		<p class="center">Zu der Anfrage wurden keine Ergebnisse gefunden.</p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>
	
	<div class="title">
	  <h2>Kategorien</h2>
	</div>
	<div class="post">
	  <ul class="catlist">
        <?php wp_list_cats('sort_column=name&hide_empty=0'); ?>	
	  </ul>
	</div>
  </div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
