<?php
/*
Plugin Name: Fold Page Menus
Plugin URI: http://jpmcc.blogdns.org/index.php/software/fold_page_menus
Description: 'Folds' Page menus, i.e. initially only Main Pages are shown in the menu. Users can display child Pages by clicking on a parent. Requires a minor edit to sidebar.php (see documentation).
Version: 1.3
Author: John McCreesh
Author URI: http://jpmcc.blogdns.org
*/

/*  Copyright 2005  John McCreesh  (email : jpmcc@phpmyedit.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

function fold_page_menus($exclusions = "") {
/*
	This function returns an exclude list for wp_list_pages
	to create a cascading menu effect.

	To implement, edit sidebar.php and add fold_page_menus
	to the call to wp_list_pages. For the WordPress default theme,
	this means changing this line:
	<?php wp_list_pages('title_li=<h2>Pages</h2>' ); ?>
	to this:
	<?php wp_list_pages(fold_page_menus().'title_li=<h2>Pages</h2>' ); ?>
*/
	global $id, $wpdb;
/*
	Find the parents of the pages to be displayed
	by working back up the tree from the current page
*/
        if (isset($id)) {
	$x = $id;
	$inclusions = "(post_parent <> " . strval($x) . ")";
	do {
		$include = $wpdb->get_results("SELECT post_parent " .
			"FROM $wpdb->posts " .
			"WHERE ID = " . $x . " " .
			"LIMIT 1",ARRAY_N);
		$x = $include[0][0];
		$inclusions .= " AND (post_parent <> " . $x . ")";
	} while ($x <> 0);
/*
	The exclude list consist of all the pages 
	whose IDs are *not* on the include list
*/
	$rows = $wpdb->get_results("SELECT ID " .
		"FROM $wpdb->posts " .
		"WHERE (post_status = 'static') AND " .
		$inclusions, ARRAY_N);
	if ( count($rows) ) {
		foreach ( $rows as $row ) {
			foreach ( $row as $ro ) {
				if ($exclusions <> "")
					$exclusions .= ",";
				$exclusions .= strval($ro);
			}
		}
	}
	} 

	if ($exclusions <> "") 
		$exclusions = "exclude=" . $exclusions . "&";

	return $exclusions;
}
?>
