<?php
// General Settings
$current = '1.1.4';

// Custom CSS Settings
function unnamed_fontcolor() {
	$color = get_option('unnamed_fontcolor');
	if (false === $color)	return '#333';
	return $color;
}

function unnamed_linkcolor() {
	$linkcolor = get_option('unnamed_linkcolor');
	if (false === $linkcolor)	return '#5D8BB3';
	return $linkcolor;
}

function unnamed_hovercolor() {
	$hovercolor = get_option('unnamed_hovercolor');
	if (false === $hovercolor) return '#3465A4';
	return $hovercolor;
}

function unnamed_bgcolor() {
	$bgcolor = get_option('unnamed_bgcolor');
	if (false === $bgcolor) return '#ddd';
	return $bgcolor;
}

// Function for seperating comments from track- and pingbacks.
function comment_type_detection($commenttxt = 'Comment',$trackbacktxt = 'Trackback',$pingbacktxt = 'Pingback') {
	global $comment;
	if (preg_match('|trackback|',$comment->comment_type))
		return $trackbacktxt;
	elseif (preg_match('|pingback|',$comment->comment_type))
		return $pingbacktxt;
	else
		return $commenttxt;
}

// Get theme info
function unnamed_info($show='') {
	echo get_unnamed_info($show);
}

function get_unnamed_info($show='') {
	global $current;

	switch ($show) {
		case 'version' :
    		$output = $current;
			break;
		case 'scheme' :
			$output = get_bloginfo('template_url') . '/styles/' . get_option('unnamed_scheme');
			break;
		case 'js_url' :
			$template_url = get_bloginfo('template_url');

			if(preg_match('/^http:\/\/[^\/]+(.+)/',$template_url,$url_parts)) {
				$output = "window.location.href.match(/^(http:\\/\\/[^\\/]+)/)[1] + '" . $url_parts[1] . "'";
			// This should never be executed,but it's well to be on the safe side
			} else {
				$output = $template_url;
			}
	}
	return $output;
}
?>
<?php
class UnnamedOptions {
	function unnamed_init() {
		load_theme_textdomain('unnamed');
		// Function for Sidebar Widgets
		if (function_exists('register_sidebar')) { register_sidebars(3,array('name'=>'Sidebar %d')); }
		//Check installation
		global $current;
		if (!get_option('unnamed_installed') || get_option('unnamed_installed') <= $current) { UnnamedOptions::unnamed_install(); }
		// Add menus
		add_action('admin_menu',array('UnnamedOptions','unnamed_add_menu'));
		// Check if this page is the one being shown,if so then add stuff to the header
		if($_GET['page'] == 'unnamed-options') {
			add_action("admin_head",array('UnnamedFunctions','unnamed_admin_css'),50);
			add_action("admin_head",array('UnnamedFunctions','unnamed_admin_js'),51);
		}
	}
	
	function unnamed_add_menu() {
		// Add the submenus
		add_submenu_page('themes.php',__('Unnamed Options','unnamed'),__('Unnamed Options','unnamed'),5,'unnamed-options','unnamed_admin');
	}

	// install unnamed
	function unnamed_install() {
		global $current;
		// Add / update the version number
		if (!get_option('unnamed_installed')) {
			add_option('unnamed_installed',$curent,'Diese Option zeigt an, ob Unnamed vorher schon installiert ist');
		} else {
			update_option('unnamed_installed',$current);
		}
		add_option('unnamed_scheme','','W&auml;hle das Schema, dass du benutzen möchtest');
		add_option('unnamed_scriptloader','0','Ausw&auml;hlen, um den Wordpress 2.1 Scriptloader zu benutzen');
		add_option('unnamed_livesearch','1',"Deaktiviere die Live-Search, um die klassische Suche zu benutzen"); 
		add_option('unnamed_shelf','1',"Wenn du JavaScript und Ajax nicht vertraust, stelle es einfach aus. Anderenfalls schlage ich vor, du l&auml;sst es aktiviert"); 
		add_option('unnamed_ajaxcommenting','1',"Deaktiven, um die klassischen Kommentare zu benutzen");
		add_option('unnamed_showsidebarpage','1',"Aktivieren, um die Sidebar auf Seiten anzuzeigen");
		add_option('unnamed_showsidebarsingle','0',"Aktivieren, um die Sidebar auf einzelnen Seiten anzuzeigen");
		add_option('unnamed_showsidebarcat','0',"Aktivieren, um die Sidebar auf den Archiv-Seiten anzuzeigen");
		add_option('unnamed_normalcss','0',"Aktivieren, um den CSS-Kompatibilitätsmodus zu aktivieren");
		add_option('unnamed_dropmenu','1',"Aktivieren, um die Drop Down Men&uuml;s anzuzeigen");
		add_option('unnamed_bgimage','1',"Aktivieren, um das Hintergund-Bild anzuzeigen");
	}
	
	// update options
	function unnamed_update() {
		if (!empty($_POST)) {
			if (isset($_POST['unnamed_scheme_file'])) {
				update_option('unnamed_scheme',$_POST['unnamed_scheme_file']);
				wp_cache_flush();
			}
			if (isset($_POST['scriptloader'])) {
				update_option('unnamed_scriptloader','1');
			} else {
				update_option('unnamed_scriptloader','0');
			}
			if (isset($_POST['livesearch'])) {
				update_option('unnamed_livesearch','1');
			} else {
				update_option('unnamed_livesearch','0');
			}
			if (isset($_POST['shelf'])) {
				update_option('unnamed_shelf','1');
			} else {
				update_option('unnamed_shelf','0');
			}
			if (isset($_POST['ajaxcommenting'])) {
				update_option('unnamed_ajaxcommenting','1');
			} else {
				update_option('unnamed_ajaxcommenting','0');
			}
			if (isset($_POST['showsidebarpage'])) {
				update_option('unnamed_showsidebarpage','1');
			} else {
				update_option('unnamed_showsidebarpage','0');
			}
			if (isset($_POST['showsidebarsingle'])) {
				update_option('unnamed_showsidebarsingle','1');
			} else {
				update_option('unnamed_showsidebarsingle','0');
			}
			if (isset($_POST['showsidebarcat'])) {
				update_option('unnamed_showsidebarcat','1');
			} else {
				update_option('unnamed_showsidebarcat','0');
			}
			if (isset($_POST['normalcss'])) {
				update_option('unnamed_normalcss','1');
			} else {
				update_option('unnamed_normalcss','0');
			}
			if (isset($_POST['dropmenu'])) {
				update_option('unnamed_dropmenu','1');
			} else {
				update_option('unnamed_dropmenu','0');
			}
			if (isset($_POST['headerheight'])) { 
				update_option('unnamed_headerheight',$_POST['headerheight']); 
			}
			if (isset($_POST['headerwidth'])) { 
				update_option('unnamed_headerwidth',$_POST['headerwidth']); 
			}
			if (isset($_POST['fontcolor'])) { 
				update_option('unnamed_fontcolor',$_POST['fontcolor']); 
			}
			if (isset($_POST['linkcolor'])) { 
				update_option('unnamed_linkcolor',$_POST['linkcolor']); 
			}
			if (isset($_POST['hovercolor'])) { 
				update_option('unnamed_hovercolor',$_POST['hovercolor']); 
			}
			if (isset($_POST['bgcolor'])) { 
				update_option('unnamed_bgcolor',$_POST['bgcolor']); 
			}
			if (isset($_POST['bgimage'])) {
				update_option('unnamed_bgimage','1');
			} else {
				update_option('unnamed_bgimage','0');
			}
			if (isset($_POST['rss'])) { 
				update_option('unnamed_rss',$_POST['rss']); 
			}
			if (isset($_POST['uninstall'])) {
				UnnamedOptions::unnamed_uninstall();
			}
		}
	}

	// uninstall unnamed
	function unnamed_uninstall() {
		global $wpdb;
		// Remove the options from the database
		$cleanup = $wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE 'unnamed%'");
		// Flush the dang cache
		wp_cache_flush();
		// Activate the default Wordpress theme
		update_option('template','default');
		update_option('stylesheet','default');
		do_action('switch_theme','Default');
		// Go back to the themes page
		echo '<meta http-equiv="refresh" content="0;URL=themes.php?activated=true">';
		echo "<script> self.location(\"themes.php?activated=true\");</script>";
		exit;
	}
}
?>
<?php
class UnnamedFunctions {
	//I get Files scan functions from K2
	function include_all($dir_path,$ignore = false) {
		// Open the directory
		$dir = @dir($dir_path) or die('Kann das ben&ouml;tigte Verzeichnis nicht &ouml;ffnen. ' . $dir_path);
		// Get all the files from the directory
		while(($file = $dir->read()) !== false) {
			// Check the file is a file,and is a PHP file
			if(is_file($dir_path . $file) and (!$ignore or !in_array($file,$ignore)) and preg_match('/\.php$/i',$file)) {
				require_once($dir_path . $file);
			}
		}
		// Close the directory
		$dir->close();
	}

	function files_scan($path,$ext = false,$depth = 1,$relative = true) {
		$files = array();
		// Scan for all matching files
		UnnamedFunctions::_files_scan($path,'',$ext,$depth,$relative,$files);
		return $files;
	}

	function _files_scan($base_path,$path,$ext,$depth,$relative,&$files) {
		if (!empty($ext)) {
			if (!is_array($ext)) {
				$ext = array($ext);
			}
			$ext_match = implode('|',$ext);
		}

		// Open the directory
		if(($dir = @dir($base_path . $path)) !== false) {
			// Get all the files
			while(($file = $dir->read()) !== false) {
				// Construct an absolute & relative file path
				$file_path = $path . $file;
				$file_full_path = $base_path . $file_path;
				// If this is a directory,and the depth of scan is greater than 1 then scan it
				if(is_dir($file_full_path) and $depth > 1 and !($file == '.' or $file == '..')) {
					UnnamedFunctions::_files_scan($base_path,$file_path . '/',$ext,$depth - 1,$relative,$files);
				// If this is a matching file then add it to the list
				} elseif(is_file($file_full_path) and (empty($ext) or preg_match('/\.(' . $ext_match . ')$/i',$file))) {
					$files[] = $relative ? $file_path : $file_full_path;
				}
			}
			// Close the directory
			$dir->close();
		}
	}

	function unnamed_admin_js() {
?>
<script type="text/javascript" src="../wp-includes/js/colorpicker.js"></script>
<script type='text/javascript'>
// <![CDATA[
function pickColor(color) {
	ColorPicker_targetInput.value = color;
	colorUpdate(ColorPicker_targetInput.id);
}
function PopupWindow_populate(contents) {
	contents += '<br /><p style="text-align:center;margin-top:0px;"><input type="button" value="<?php _e('Color-Picker schließen','unnamed') ?>" onclick="cp.hidePopup(\'prettyplease\')"></input></p>';
	this.contents = contents;
	this.populated = false;
}
function PopupWindow_hidePopup(magicword) {
	if (magicword != 'prettyplease')
		return false;
	if (this.divName != null) {
		if (this.use_gebi) {
			document.getElementById(this.divName).style.visibility = "hidden";
		}
		else if (this.use_css) {
			document.all[this.divName].style.visibility = "hidden";
		}
		else if (this.use_layers) {
			document.layers[this.divName].visibility = "hidden";
		}
	}
	else {
		if (this.popupWindow && !this.popupWindow.closed) {
			this.popupWindow.close();
			this.popupWindow = null;
		}
	}
	return false;
}
function colorSelect(t,p) {
	if (cp.p == p && document.getElementById(cp.divName).style.visibility != "hidden")
		cp.hidePopup('prettyplease');
	else {
		cp.p = p;
		cp.select(t,p);
	}
}
var cp = new ColorPicker();
function advUpdate(val,obj) {
	document.getElementById(obj).value = val;
	colorUpdate(obj);
}
function colorUpdate(oid) {
	if ('fontcolor' == oid) {
		document.getElementById('unnamedfontcolor').style.color = document.getElementById('fontcolor').value;
		document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value;
	}
	
	if ('linkcolor' == oid) {
		document.getElementById('unnamedlinkcolor').style.color = document.getElementById('linkcolor').value;
		document.getElementById('advlinkcolor').value = document.getElementById('linkcolor').value;
	}
	
	if ('hovercolor' == oid) {
		document.getElementById('unnamedhovercolor').style.color = document.getElementById('hovercolor').value;
		document.getElementById('advhovercolor').value = document.getElementById('hovercolor').value;
	}
	
	if ('bgcolor' == oid) {
		document.getElementById('unnamedbgcolor').style.background = document.getElementById('bgcolor').value;
		document.getElementById('advbgcolor').value = document.getElementById('bgcolor').value;
	}
}
function toggleAdvanced() {
	a = document.getElementById('advanced');
	if (a.style.display == 'none')
		a.style.display = 'block';
	else
		a.style.display = 'none';
}
function toggleStyle() {
	m = document.getElementById('togglestyle');
	if (m.style.display == 'none')
		m.style.display = 'block';
	else
		m.style.display = 'none';
}
function toggleMisc() {
	m = document.getElementById('togglemisc');
	if (m.style.display == 'none')
		m.style.display = 'block';
	else
		m.style.display = 'none';
}
function colorDefaults() {
	document.getElementById('unnamedfontcolor').style.color = '#333';
	document.getElementById('unnamedlinkcolor').style.color = '#5D8BB3';
	document.getElementById('unnamedhovercolor').style.color = '#3465A4';
	document.getElementById('unnamedbgcolor').style.background = '#ddd';
	document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value = '#333';
	document.getElementById('advlinkcolor').value = document.getElementById('linkcolor').value = '#5D8BB3';
	document.getElementById('advhovercolor').value = document.getElementById('hovercolor').value = '#3465A4';
	document.getElementById('advbgcolor').value = document.getElementById('bgcolor').value = '#ddd';
}
// ]]>
</script>
<?php } function unnamed_admin_css() { ?>
<style type="text/css">	
body {font:62.5% "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;}
h2 {font:2.4em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;border:0;margin:5px 0 !important;}
h3 {font:1.8em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;margin:5px 0;color:#333;}
h4 {font:1.5em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;margin:5px 0 0;color:#333;}
small {color:#777;font-size:.9em;}
.wrap {font-size:1.2em;}
.unnamedcontainer {width:800px;margin:0 auto;text-align:left;color:#333;}
.unnamedcontainer input[type=checkbox],.unnamedcontainer input[type=radio] {border:0;}
.unnamedoptions {clear:both;width:780px;margin:0 0 20px;padding:10px;border:1px solid #ccc;}
.floatleft {float:left;width:250px;padding:0 5px;}
#admin-content {height:50px;width:390px;margin:0 100px;background:url(<?php bloginfo('template_directory'); ?>/images/bg_admin_content.png) transparent center top repeat-y;}
#unnamedbgcolor {margin:8px 0 0;height:50px;width:600px;}
#unnamedfontcolor {float:left;text-align:center;margin:15px 10px 5px 40px;}
#unnamedlinkcolor {float:left;text-align:center;margin:15px 10px 5px 30px;}
#unnamedhovercolor {float:left;text-align:center;margin:15px 40px 5px 30px;}
#advanced,#togglestyle,#togglemisc {marign:10px 0;}
#colorPickerDiv a,#colorPickerDiv a:hover {padding:1px;text-decoration: none;border-bottom: 0px;}
.clear {clear:both;}
</style>
<?php } } function unnamed_admin() {
	global $wpdb;
	// Update
	$update = UnnamedOptions::unnamed_update();
	// Get the current unnamed style
	$scheme_name = get_option('unnamed_scheme');
	$scheme_title = $scheme_name !== false ? $scheme_name : __('Kein Style','unnamed');
	// Get the scheme files
	$scheme_files = UnnamedFunctions::files_scan(TEMPLATEPATH . '/styles/','css',2);
?>
<?php if(isset($_POST['submit'])) : ?>
<div id="message2" class="updated fade">
  <p>
    <?php _e('Optionen sind aktualisiert worden.','unnamed'); ?>
  </p>
</div>
<?php endif; ?>
<div class="wrap">
  <h2>
    <?php _e('Theme-Optionen f&uuml;r Unnamed','unnamed'); ?>
  </h2>
  <p style="margin-left:5px;"><small><?php printf(__('Du kannst immer die aktuellste Version von Unnamed <a href="http://xuyiyang.com/wordpress-themes/unnamed/">hier bekommen</a>.','unnamed')) ?></small></p>
  <div class="unnamedcontainer">
    <form name="dofollow" action="" method="post">
      <input type="hidden" name="action" value="<?php echo($update); ?>" />
      <input type="hidden" name="page_options" value="'dofollow_timeout'" />
      <p class="submit">
        <input type="submit" name="submit" value="<?php _e('Update Optionen','unnamed'); ?> &raquo;" />
      </p>
      <h3>
        <?php _e('AJAX-Optionen','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <div class="floatleft">
          <h4>
            <?php _e('Live-Search','unnamed'); ?>
          </h4>
          <p>
            <input name="livesearch" id="livesearch" type="checkbox" value="1" <?php checked('1',get_option('unnamed_livesearch')); ?> />
            <label for="livesearch">
            <?php _e('Aktiviere die Live-Search','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Live-Kommentare','unnamed'); ?>
          </h4>
          <p>
            <input name="ajaxcommenting" id="ajaxcommenting" type="checkbox" value="1" <?php checked('1',get_option('unnamed_ajaxcommenting')); ?> />
            <label for="ajaxcommenting">
            <?php _e('Aktiviere die Live-Kommentare','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Sliding Effect','unnamed'); ?>
          </h4>
          <p>
            <input name="shelf" id="shelf" type="checkbox" value="1" <?php checked('1',get_option('unnamed_shelf')); ?> />
            <label for="shelf">
            <?php _e('Aktiviere den Sliding Effect','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Scriptloader','unnamed'); ?>
          </h4>
          <p>
            <input name="scriptloader" id="scriptloader" type="checkbox" value="1" <?php checked('1',get_option('unnamed_scriptloader')); ?> />
            <label for="scriptloader">
            <?php _e('Aktiviere den Scriptloader','unnamed'); ?>
            </label>
          </p>
        </div>
        <p class="clear"><small>
          <?php _e('Aktiviere den WordPress 2.1 Scriptloader f&uuml;r eine bessere Plugin-Kompatibilit&auml;t. Deaktiviere diesen f&uuml;r eine bessere Performance.','unnamed'); ?>
          </small></p>
      </div>
      <h3>
        <?php _e('Eigene Styles','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <div style="width:100%;">
          <h4>
            <?php _e('Styles','unnamed'); ?>
          </h4>
          <p>
            <select style="width:350px;" name="unnamed_scheme_file" id="scheme_file">
              <option value=""<?php selected($scheme_name,''); ?>>
              <?php _e('Kein Style','unnamed'); ?>
              </option>
              <?php foreach($scheme_files as $scheme_file) { ?>
              <option value="<?php echo($scheme_file); ?>"<?php selected($scheme_name,$scheme_file); ?>><?php echo($scheme_file); ?></option>
              <?php } ?>
            </select>
          </p>
          <p><small>
            <?php _e('W&auml;hle den Style, den du auf deinen Seiten nutzen m&ouml;chtest.','unnamed'); ?>
            </small></p>
          <h4>
            <?php _e('CSS-Modus','unnamed'); ?>
          </h4>
          <p>
            <input name="normalcss" id="normalcss-on" type="checkbox" value="1" <?php checked('1',get_option('unnamed_normalcss')); ?> />
            <label for="normalcss-on">
            <?php _e('Aktiviere den CSS-Kompatibilitätsmodus','unnamed'); ?>
            </label>
          </p>
          <p><small>
            <?php _e('Bitte nur aktivieren, wenn die Datei style.css.php auf Deiner Webseite nicht fehlerfrei funktioniert. Wenn der Kompatibilitätsmodus aktiviert ist, werden keine eigenen Styles und eigene Header-Bilder &uuml;bernommen!','unnamed'); ?>
            </small></p>
          <h4>
            <?php _e('Farben','unnamed'); ?>
          </h4>
          <div id="unnamedbgcolor" style="background:<?php echo unnamed_bgcolor(); ?>;">
            <div id="admin-content">
              <p id="unnamedfontcolor" style="color:<?php echo unnamed_fontcolor(); ?>;">
                <?php _e('Schrift-Farbe','unnamed'); ?>
              </p>
              <p id="unnamedlinkcolor" style="color:<?php echo unnamed_linkcolor(); ?>;">
                <?php _e('Link-Farbe','unnamed'); ?>
              </p>
              <p id="unnamedhovercolor" style="color:<?php echo unnamed_hovercolor(); ?>;">
                <?php _e('Link-Hover-Farbe','unnamed'); ?>
              </p>
            </div>
          </div>
          <br class="clear" />
          <input type="button" onclick="tgt=document.getElementById('fontcolor');colorSelect(tgt,'pick1');return false;" name="pick1" id="pick1" value="<?php _e('Schrift-Farbe','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('linkcolor');colorSelect(tgt,'pick2');return false;" name="pick2" id="pick2" value="<?php _e('Link-Farbe','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('hovercolor');colorSelect(tgt,'pick3');return false;" name="pick3" id="pick3" value="<?php _e('Link-Hover-Farbe','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('bgcolor');colorSelect(tgt,'pick4');return false;" name="pick4" id="pick4" value="<?php _e('Hintergrund-Farbe','unnamed'); ?>" />
          <input type="hidden" name="fontcolor" id="fontcolor" value="<?php echo get_option('unnamed_fontcolor'); ?>" />
          <input type="hidden" name="linkcolor" id="linkcolor" value="<?php echo get_option('unnamed_linkcolor'); ?>" />
          <input type="hidden" name="hovercolor" id="hovercolor" value="<?php echo get_option('unnamed_hovercolor'); ?>" />
          <input type="hidden" name="bgcolor" id="bgcolor" value="<?php echo get_option('unnamed_bgcolor'); ?>" />
          <input type="button" name="default" value="<?php _e('Standard-Farben','unnamed'); ?>" onclick="colorDefaults()" />
          <input type="button" value="<?php _e('Erweitert','unnamed'); ?>" onclick="toggleAdvanced()" />
          <div id="colorPickerDiv" style="z-index:100;background:#eee;border:1px solid #ccc;position:absolute;visibility:hidden;"> </div>
          <div id="advanced" style="display:none;"> <br />
            <label for="advfontcolor">
            <?php _e('Schrift-Farbe:','unnamed'); ?>
            </label>
            <input type="text" id="advfontcolor" onchange="advUpdate(this.value,'fontcolor')" value="<?php echo get_option('unnamed_fontcolor'); ?>" />
            <br />
            <label for="advlinkcolor">
            <?php _e('Link-Farbe:','unnamed'); ?>
            </label>
            <input type="text" id="advlinkcolor" onchange="advUpdate(this.value,'linkcolor')" value="<?php echo get_option('unnamed_linkcolor'); ?>" />
            <br />
            <label for="advhovercolor">
            <?php _e('Link-Hover-Farbe:','unnamed'); ?>
            </label>
            <input type="text" id="advhovercolor" onchange="advUpdate(this.value,'hovercolor')" value="<?php echo get_option('unnamed_hovercolor'); ?>" />
            <br />
            <label for="advbgcolor">
            <?php _e('Hintergrund-Farbe:','unnamed'); ?>
            </label>
            <input type="text" id="advbgcolor" onchange="advUpdate(this.value,'bgcolor')" value="<?php echo get_option('unnamed_bgcolor'); ?>" />
            <br />
            <label for="bgimage">
            <?php _e('Hintergrund-Bild:','unnamed'); ?>
            </label>
            <input name="bgimage" id="bgimage" type="checkbox" value="1" <?php checked('1',get_option('unnamed_bgimage')); ?> />
            <br />
          </div>
          <p><small>
            <?php _e('Ver&auml;nderungen der Hintergrund-Farbe werden nicht mit dem IE 6.0 angezeigt.','unnamed');?>
            </small></p>
        </div>
      </div>
      <span style="float:right">
      <input type="button" value="<?php _e('Weitere Optionen','unnamed'); ?> &raquo;" onclick="toggleMisc()" />
      </span>
      <h3>
        <?php _e('Verschiedenes','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <h4>
          <?php _e('Feed-Adresse','unnamed'); ?>
        </h4>
        <p>
          <input type="text" style="width:350px;" name="rss" value="<?php echo (get_option('unnamed_rss')); ?>" />
        </p>
        <p><small>
          <?php _e('Du k&ouml;nntest deinen Feedburner nutzen, um den Standard RSS 2.0 Feed zu ersetzen.<br />Zum Beispiel: http://feeds.feedburner.com/deinefeedadresse','unnamed'); ?>
          </small></p>
        <div id="togglemisc" style="display:none;">
          <div class="floatleft">
            <h4>
              <?php _e('Header-Gr&ouml;ße','unnamed'); ?>
            </h4>
            <p>
              <label for="headerheight">
              <?php _e('Header-H&ouml;he','unnamed'); ?>
              </label>
              <input type="text" style="width:32px;" id="headerheight" name="headerheight" value="<?php echo get_option('unnamed_headerheight'); ?>" />
              px. <br />
              <label for="headerwidth">
              <?php _e('Header-Weite','unnamed'); ?>
              </label>
              <input type="text" style="width:32px;" id="headerwidth" name="headerwidth" value="<?php echo get_option('unnamed_headerwidth'); ?>" />
              px. </p>
          </div>
          <div class="floatleft">
            <h4>
              <?php _e('Zeige Sidebar-Eintr&auml;ge','unnamed'); ?>
            </h4>
            <p>
              <input name="showsidebarpage" id="onpage" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarpage')); ?> />
              <label for="onpage">
              <?php _e('auf statischen Seiten','unnamed'); ?>
              </label>
              <br />
              <input name="showsidebarsingle" id="onsingle" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarsingle')); ?> />
              <label for="onsingle">
              <?php _e('auf einzelnen Beitr&auml;gen','unnamed'); ?>
              </label>
              <br />
              <input name="showsidebarcat" id="onarchive" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarcat')); ?> />
              <label for="onarchive">
              <?php _e('auf Archiv-Seiten','unnamed'); ?>
              </label>
            </p>
          </div>
          <div class="floatleft">
            <h4>
              <?php _e('Drop Down Men&uuml;','unnamed'); ?>
            </h4>
            <p>
              <input name="dropmenu" id="dropmenu-on" type="checkbox" value="1" <?php checked('1',get_option('unnamed_dropmenu')); ?> />
              <label for="dropmenu-on">
              <?php _e('Aktiviere Drop Down Men&uuml;','unnamed'); ?>
              </label>
            </p>
          </div>
          <p class="clear"><small>
            <?php _e('W&auml;hle den Header deinen W&uuml;nschen entsprechend, indem du zum Beispiel <a href="themes.php?page=custom-header">ein Bild hochl&auml;dst</a>.','unnamed'); ?>
            </small></p>
        </div>
      </div>
      <br class="clear" />
      <p class="submit">
        <input type="submit" name="submit" value="<?php _e('Aktualisiere Optionen','unnamed'); ?> &raquo;" />
      </p>
    </form>
    <h3>
      <?php _e('Spende','unnamed'); ?>
    </h3>
    <p><?php printf(__('Hier kannst du eine Spende mit <a href="http://www.paypal.com">Paypal</a> leisten, um dieses Projekt am Laufen zu halten. Spenden werden in jeder Form gesch&auml;tzt. Danke!','unnamed')) ?></p>
    <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
      <p>
        <input type="hidden" name="cmd" value="_s-xclick" />
        <input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but21.gif" style="border:0;" name="submit" alt="Make payments with PayPal - it's fast, free and secure!" />
        <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----" />
      </p>
    </form>
    <h3>
      <?php _e('Deinstallieren ','unnamed'); ?>
    </h3>
    <p><?php printf(__('Dr&uuml;cke den Deinstallieren-Button, um die Datenbank aufzur&auml;umen. Du wirst dann zu der <a href="themes.php">Themes-Seite</a> umgeleitet. <br />Dieses wird nicht dein eigenes Bild im Header entfernen, du kannst den Original Header auf <a href="themes.php?page=custom-header">dieser Seite</a> wiederherstellen.','unnamed')) ?></p>
    <form action="" method="post">
      <p class="submit">
        <input name="uninstall" id="uninstall" class="button" type="submit" value="<?php _e('Deinstalliere Theme','unnamed'); ?> &raquo;" />
      </p>
    </form>
  </div>
</div>
<?php  } 
// Custom Image Header Functions
define('HEADER_TEXTCOLOR','FFFFFF');
define('HEADER_IMAGE','%s/images/bg_header.png'); // %s is theme dir uri

if (get_option('unnamed_headerheight') == "") { define('HEADER_IMAGE_HEIGHT',78);
} else {
define('HEADER_IMAGE_HEIGHT',$css_headerheight);
}

if (get_option('unnamed_headerwidth') == "") { define('HEADER_IMAGE_WIDTH',960);
} else {
define('HEADER_IMAGE_WIDTH',$css_headerwidth);
}

function admin_header_style() {
?>
<style type="text/css">
#headimg {
background-image:url(<?php header_image() ?>);
background-repeat:repeat !important;
height:<?php echo HEADER_IMAGE_HEIGHT; ?>px;
width:<?php echo HEADER_IMAGE_WIDTH; ?>px;
margin:0 0 10px;
}
#headimg h1 {
font-size:1.8em;
text-align:left;
margin:0;
padding:15px 0 0 20px;
}
#headimg h1 a {
color:#<?php header_textcolor() ?>;
text-decoration: none;
border-bottom: none;
}
#headimg #desc {
color:#<?php header_textcolor() ?>;
font-size:1em;
text-align:left;
padding:0 0 5px 20px;
}
<?php if ('blank' == get_header_textcolor()) { ?>
#headimg h1,#headimg #desc {
display:none;
}
#headimg h1 a,#headimg #desc {
color:#<?php echo HEADER_TEXTCOLOR ?>;
}
<?php } ?>
</style>
<?php }

UnnamedOptions::unnamed_init();

if($wp_version>=2.1) {
	wp_register_script('unnamed_livesearch',get_bloginfo('template_directory') . '/js/livesearch.js.php',array('scriptaculous-effects'));
	wp_register_script('unnamed_comments',get_bloginfo('template_directory') . '/js/comments.js.php',array('scriptaculous-effects'));
	wp_register_script('unnamed_functions',get_bloginfo('template_directory') . '/js/functions.js.php',array('scriptaculous-effects'));
	add_custom_image_header('','admin_header_style');
}
?>
