<?php
	require(dirname(__FILE__)."/../../../../wp-blog-header.php");

	// check to see if the user has enabled gzip compression in the WordPress admin panel
	if ( !get_settings('gzipcompression') and !ini_get('zlib.output_compression') and ini_get('output_handler') != 'ob_gzhandler' and ini_get('output_handler') != 'mb_output_handler' ) {
		ob_start('ob_gzhandler');
	}

	// The headers below tell the browser to cache the file and also tell the browser it is JavaScript.
	header("Cache-Control: public");
	header("Pragma: cache");

	$offset = 60*60*24*60;
	$ExpStr = "Expires: ".gmdate("D, d M Y H:i:s",time() + $offset)." GMT";
	$LmStr = "Last-Modified: ".gmdate("D, d M Y H:i:s",filemtime(__FILE__))." GMT";

	header($ExpStr);
	header($LmStr);
	header('Content-Type: text/javascript; charset: UTF-8');
?>
Livesearch = Class.create();

Livesearch.prototype = {
	initialize: function(father, url, pars, attachitem, contentitem, loaditem, resetitem, searchtext) {
		this.father = father;
		this.attachitem = attachitem;
		this.contentitem = contentitem;
		this.resetitem = resetitem;
		this.url = url;
		this.pars = pars;
		this.loaditem = loaditem;
		this.searchtext = searchtext;
		this.t = null;  // Init timeout variable
		
		$(father).innerHTML = '<input type="text" id="searchinput" name="s" autocomplete="off" value="'+searchtext+'" /><img src="<?php echo get_bloginfo('template_directory'); ?>/images/transparent.gif" alt="Clear Search Results" title="Clear Search Results" id="search-reset" style="display:none;" /><img src="<?php echo get_bloginfo('template_directory'); ?>/images/transparent.gif" alt="Loading Search Results" id="search-loading" style="display:none;" /><div id="search-results" style="display:none;"></div>';
		
		// Style the searchform for livesearch
		$(this.resetitem).hide();
		$(this.loaditem).hide();

		Event.observe(attachitem, 'focus', function() { if ($(attachitem).value == searchtext) $(attachitem).setAttribute('value', '') });
		Event.observe(attachitem, 'blur', function() { if ($(attachitem).value == '') $(attachitem).setAttribute('value', searchtext) });

		// Bind the keys to the input
		Event.observe(attachitem, 'keyup', this.readyLivesearch.bindAsEventListener(this));
	},

	readyLivesearch: function(event) {
		var code = event.keyCode;
		var currentLivesearch = this;
		if (code == Event.KEY_ESC || ((code == Event.KEY_DELETE || code == Event.KEY_BACKSPACE) && $F(this.attachitem) == '')) {
			this.resetLivesearch();
		} else if (code != Event.KEY_LEFT && code != Event.KEY_RIGHT && code != Event.KEY_DOWN && code != Event.KEY_UP && code != Event.KEY_RETURN) {
			if (this.t) { clearTimeout(this.t) };
	        this.t = setTimeout(this.doLivesearch.bind(this), 400);
		}
	},

	searchComplete: function() {
		Event.observe(this.resetitem, 'click', this.resetLivesearch.bindAsEventListener(this));
		Effect.Fade(this.loaditem, {duration: .1});
		Effect.Appear(this.resetitem, { duration: .8 });
		Effect.Appear(this.contentitem, {duration: .5});
	},

	doLivesearch: function() {
		$(this.resetitem).hide();
		Effect.Appear(this.loaditem, {duration: .1});
		new Ajax.Updater(
			this.contentitem,
			this.url,
			{
				method: 'get',
				parameters: this.pars + encodeURIComponent($F(this.attachitem)),
				onSuccess: this.searchComplete.bind(this)
		});
	},

	resetLivesearch: function() {
		Effect.Fade(this.resetitem, { duration: .7 });
		Effect.Fade(this.contentitem, {duration: .5});
		$(this.attachitem).value = '';
	}
}

FastInit.addOnLoad( function() { new Livesearch('searchform', '<?php bloginfo('template_url'); ?>/livesearch.php', 'searchquery=', 'searchinput', 'search-results', 'search-loading', 'search-reset', '<?php _e('Eingeben und warten','unnamed'); ?>'); } );