<?php
	require_once(dirname(__FILE__)."/../../../wp-blog-header.php");
	// check to see if the user has enabled gzip compression in the WordPress admin panel
	if ( ob_get_length() === FALSE and !ini_get('zlib.output_compression') and ini_get('output_handler') != 'ob_gzhandler' and ini_get('output_handler') != 'mb_output_handler' ) {
		ob_start('ob_gzhandler');
	}
	header('Content-Type: text/css; charset: UTF-8');
?>
/* General */
html { /* Force Vertical Scrollbar */
/* IE */
overflow-y:scroll; 
/* Moz */
height:100%;
margin-bottom:1px;
}

* {
padding:0;
margin:0;
}

body {
font:62.5% "Lucida Grande", Arial, Helvetica, Verdana, sans-serif;
color:<?php echo unnamed_fontcolor(); ?>;
text-align:center;
background:<?php if(get_option('unnamed_bgimage') == 1) { ?>url(images/bg_body.png) repeat top center<?php } ?> <?php echo unnamed_bgcolor(); ?> !important;
background:#ddd;
}

fieldset,select,img {
border:0;
}

hr,#searchform br,.counter {
display:none;
}

a,a:link,a:active,a:visited {
color:<?php echo unnamed_linkcolor(); ?>;
text-decoration:none;
}

a:hover {
color:<?php echo unnamed_hovercolor(); ?>;
text-decoration:underline;
}

p {
margin:0 0 10px;
}

ol li {
list-style:decimal outside;
}

acronym,abbr,span.caps {
cursor:help;
}

acronym,abbr {
border-bottom:1px dashed #fc0;
}

blockquote {
border-left:3px solid #ccc;
margin:20px;
padding-left:10px;
}

cite,ins {
text-decoration:none;
}

code,pre,kbd {
font:1em 'Courier New',Courier,sans-serif;
}

small {
font:0.8em Arial,Helvetica,sans-serif;
color:#777;
}

strike,del {
color:#777;
text-decoration:line-through;
}

label {
cursor:pointer;
}

h1,h2,h3,h4 {
font-family:"Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;
font-weight:700;
}

h1 {
font-size:1.8em;
text-align:left;
padding:22px 0 5px 20px;
}

h1 a,h1 a:link,h1 a:active,h1 a:hover,h1 a:visited {
color:#fff;
background:none;
}

h2 {
margin:5px 0;
font-size:1.2em;
}

h3,h4 {
margin:20px 0 0;
font-size:1.2em;
}

/* Structure Divs */
#header {
margin:0 auto;
line-height:1.2em;
<?php if(get_option('unnamed_headerheight') == "") { ?>
height:78px;
<?php } else { ?>
height:<?php echo($css_headerheight); ?>px;
<?php }?>
<?php if(get_option('unnamed_scheme') == "") { ?>
width:960px;
<?php } ?>
background:url(<?php header_image() ?>) transparent repeat top center;
}

#container {
position:relative;
margin:0 auto;
font-size:1.2em;
<?php if(get_option('unnamed_scheme') == "") { ?>
width:970px;
background:url(images/bg_content.png) repeat-y center top transparent !important;
background:url(images/ie6/bg_content.png) repeat-y center top;
<?php } ?>
}

#content {
<?php if(get_option('unnamed_scheme') == "") { ?>
width:960px;
<?php } ?>
background:#fff;
margin:0 auto;
}

#primary-content {
float:left;
text-align:left;
line-height:1.6em;
margin:0 1.5% !important;
margin:0 2% 0 1.1%;
width:500px;
display:inline;
overflow:hidden;
}

#footer {
clear:both;
height:80px;
margin:0 auto;
<?php if(get_option('unnamed_scheme') == "") { ?>
width:970px;
background:url(images/bg_footer.png) no-repeat top center transparent !important;
background:url(images/ie6/bg_footer.png) no-repeat top center #ddd;
<?php } ?>
}

#sidebar {
float:left;
line-height:1.4em;
margin:20px 1.5% !important;
margin:20px 0;
<?php if(get_option('unnamed_scheme') == "") { ?>
width:400px;
<?php } ?>
text-align:left;
}

/* Config Structure Divs */
	/* Header and Navigation */
	.description {
	font-size:1em;
	text-align:left;
	padding:0 0 5px 20px;
	}
	
	<?php if (get_header_textcolor()=='blank' ) { ?>
	#header h1, .description {
	display:none;
	}
	<?php } else { ?>
	#header h1 a, .description {
	color:#<?php header_textcolor() ?>;
	}
	<?php } ?>
	
	.pagetitle {
	margin-top:25px;
	text-align:center;
	}
	
	#nav {
	display:block;
	height:32px;
	margin:0 auto !important;
	margin:0;
	padding:0;
	text-align:left;
	letter-spacing:0.15em;
	text-transform:uppercase;
	<?php if(get_option('unnamed_scheme') == "") { ?>width:960px;<?php } ?>
	background:url(images/bg_nav.png) repeat-x left top transparent;
	list-style:none;
	z-index:8;
	}
	
	#nav li {
	float:left;
	padding:0;
	margin:0;
	}
	
	#nav li a { 
	display:block;
	line-height:32px;
	padding:0 10px;
	color:#fff;
	text-decoration:none;
	}
	
	#nav li a:hover { 
	color:#fff;
	background:#333;
	}
	
	<?php if(get_option('unnamed_dropmenu') == 1) { ?>
	#nav li li {
	width:200px;
	}
	
	#nav ul a {
	color:#fff;
	line-height:24px;
	}

	#nav ul{
	position:absolute;
	z-index:500;
	top:auto;
	list-style:none;
	display:none;
	width:200px;
	list-style:none;
	text-align:center;
	border:1px solid #333;   
	background:url(images/bg_nav_ul.png) repeat left top transparent !important;
	background:#999;
	}

	#nav ul ul{
	top:0;
	left:100%;
	}
	
	#nav li:hover, #nav li.sfhover{
	color:#fff;
	background:#333;
	cursor:pointer;
	z-index:100;
	}
	
	#nav li:hover ul ul,
	#nav li li:hover ul ul,
	#nav li li li:hover ul ul,
	#nav li li li li:hover ul ul,
	#nav li.sfhover ul ul,
	#nav li li.sfhover ul ul,
	#nav li li li.sfhover ul ul,
	#nav li li li li.sfhover ul ul
	{display:none;}
	
	#nav li:hover ul,
	#nav li li:hover ul,
	#nav li li li:hover ul,
	#nav li li li li:hover ul,
	#nav li.sfhover  ul,
	#nav li li.sfhover  ul,
	#nav li li li.sfhover  ul,
	#nav li li li li.sfhover  ul
	{display:block;}
	<?php } ?>
	
	/* Primary Cotent and Entries */
	.content-top {
<?php if(get_option('unnamed_scheme') == "") { ?>
	background:url(images/bg_content_top.png) no-repeat top center;
<?php } ?>
	text-align:right;
	height:15px;
	width:100%;
	}
	
	.content-top a {
	font-size:.9em;
	margin:5px 15px 0;
	}

	.entry {
	text-align:left;
	padding:20px 8px;
	}
	
	.entry ul,.entry ol {
	margin:0 0 0 40px;
	}
	
	.entry li {
	padding-bottom:8px;
	}
	
	.entry-header {
	background:url(images/bg_entry_header.png) left bottom no-repeat;
	font-size:1.6em;
	margin:0;
	padding:2px 0;
	}
	
	.date-header {
	font-size:0.9em;
	color:#ccc;
	text-align:right;
	margin:0 0 10px;
	padding:0 5px;
	line-height:1.2em;
	}
	
	.entry-footer {
	color:#ccc;
	font-size:0.9em;
	text-align:right;
	background:url(images/bg_entry_header.png) left top no-repeat;
	margin:0 0 20px;
	padding:1px;
	line-height:1.4em;
	}
	
	/* Sidebar */
	#sidebar h2 {
	color:#333;
	font-size:1.2em;
	font-weight:400;
	text-transform:uppercase;
	margin:15px 2px 0 10px;
	padding:2px 0;
	}
	
	#sidebar ul {
	color:#777;
	list-style:none;
	}
	
	#sidebar li {
	width:100%;
	}
	
	#sidebar ul ul li {
	width:100%;
	margin:0 10px;
	padding:2px;
	}
	
	#sidebar ul ul li a,#sidebar ul ul li a:link,#sidebar ul ul li a:visited {
	padding:2px 4px;
	}
	
<?php if(get_option('unnamed_scheme') == "") { ?>
	.left-sidecolumn {
	clear:left;
	float:left;
	width:55%;
	padding:0 0 0 5px;
	}
	
	.right-sidecolumn {
	clear:right;
	float:right;
	width:38%;
	padding:0 5px 0 0;
	}
<?php } ?>
	
	.intro {
	color:#777;
	width:90%;
	margin:5px;
	padding:5px;
	text-align:left;
	}
	
<?php if(get_option('unnamed_shelf') == 1) { ?>
	/* Shelf Elements */	
	#shelf {
	float:left;
	line-height:1.4em;
	width:100%;
	}
	
	#toggle {
	<?php if(get_option('unnamed_scheme') == "") { ?>
	width:960px;
	<?php } ?>
	margin:0 auto !important;
	margin:0;
	text-align:left;
	background:#000;
	list-style:none;
	overflow:hidden;
	}
	
	#toggle h2 {
	color:#fff;
	font-size:1.2em;
	font-weight:400;
	text-transform:uppercase;
	margin:15px 2px 0;
	}
	
	#toggle ul {
	list-style:none;
	margin:10px 0 10px;
	}
	
	#toggle li {
	float:left;
	width:21%;
	background:transparent;
	margin-left:1.8% !important;
	margin-left:1.5%;
	padding:0 4px 6px 4px;
	display:inline;
	}
	
	* html #toggle li {
	width:20%;
	}
	
	#toggle ul li {
	width:100%;
	margin:2px 0;
	padding:0 8px;
	}
	
	#toggle ul li a,#toggle ul li a:link,#toggle ul li a:visited {
	display:block;
	background:transparent;
	color:#fff;
	white-space:nowrap;
	padding:2px;
	border-top:1px solid <?php echo unnamed_hovercolor(); ?>;
	border-bottom:1px solid <?php echo unnamed_hovercolor(); ?>;
	text-decoration:none;
	}
	
	#toggle ul li a:hover {
	border-top:1px solid #fc0;
	border-bottom:1px solid #fc0;
	}
	
	#toggle li.tags {
	width:45%;
	}
	
	#toggle li.tags a:hover {
	background:none;
	text-decoration:underline;
	}
<?php } ?>
	
	#sidebar ul ul,#toggle ul {
	margin:0;
	padding:0 0 10px;
	}
	
	/* Footer */
	#footer p {
	color:#fff;
	text-align:center;
	font-size:.9em;
	line-height:1.5em;
	padding:28px 0 5px;
	}

/* Search */
li#search {
width:95%;
margin:2px 3%;
line-height:1em;
}

#searchform {
color:#fff;
padding:0 0 5px 0;
display:block;
}

#searchform input {
border:0;
color:#fff;
margin:2px 4px;
}

#searchform input#searchinput {
width:92%;
color:#333;
border:1px solid #ccc;
background:url(images/bg_search.jpg) no-repeat right -24px #fff;
margin:5px 0 2px;
padding:3px;
}

#searchform input#searchinput:focus {
border:1px solid #fc0;
background:url(images/bg_search.jpg) no-repeat right 0 #fff;
}

<?php if(get_option('unnamed_livesearch') == 1) { ?>
#live-results {
color:#333;
margin:0;
padding:2px 0;
}

#live-results h2 {
display:block;
margin:5px 0;
padding:0;
}

#live-results h3 {
font-size:1em;
font-weight:400;
margin:0;
padding:0;
}

#live-results .more-results {
display:block;
background:url(images/search-more.png) left center no-repeat;
margin:5px 15px 0 0;
padding:2px 0 2px 18px;
}

#search-loading {
height:18px;
width:18px;
background:url(images/spinner.gif) center center no-repeat;
}

#search-reset {
height:18px;
width:18px;
background:url(images/cancel.png) center center no-repeat;
cursor:pointer;
}

#search-results ul {
margin:0;
padding:0;
}

#search-results li {
background:url(images/item.png) left center no-repeat;
margin:0;
padding:0;
}

#search-results h3 {
margin:0;
padding:0 0 0 8px;
}
<?php } ?>
/* Comments and Trackbacks */
#comment-section {
margin:40px 0 0;
text-align:left;
}

#leavecomment {
text-align:center;
color:#ccc;
font-size:1.8em;
letter-spacing:-1px;
margin:35px 0;
}

#commentform {
margin:15px 0;
padding:10px;
}

input#author,input#email,input#url,textarea#comment {
border:1px solid #ccc;
padding:1px;
background:url(images/bg_input.jpg) repeat-x left top;
}

#commentform input:focus,#commentform textarea:focus {
color:#3377E3;
border:1px solid #fc0;
}

textarea#comment {
width:99%;
}

#submit,#previewcomment {
float:right;
margin:0 0 0 10px;
border:1px solid <?php echo unnamed_hovercolor(); ?>;
color:#fff;
background:<?php echo unnamed_linkcolor(); ?>;
padding:0 2px;
}

#submit:hover,#previewcomment:hover {
background:<?php echo unnamed_hovercolor(); ?>;
}

.comment-header {
font-size:1.8em;
color:#ccc;
}

.comment-header a,.comment-header a:active,.comment-header a:visited,.comment-header a:link {
color:#ccc;
background:none;
}

.comment-header a:hover {
color:#ccc;
background:none;
text-decoration:underline;
}

.comment-content {
width:94%;
}

.comment-footer {
font-size:.9em;
margin:4px 0;
padding:0;
}

.commentlist,.pinglist {
list-style:none;
margin:10px 0;
}

.commentlist li {
width:94%;
list-style:none;
padding:4px;
line-height:1.8em;
}

.commentlist p {
margin:10px;
}

.class-comment1 {
margin:15px 10px;
border:1px solid <?php echo unnamed_linkcolor(); ?>;
}

.class-comment2 {
margin:15px 10px;
border:1px solid #ccc;
}

.pinglist li {
width:94%;
border:1px solid <?php echo unnamed_hovercolor(); ?>;
list-style:none;
margin:15px 10px;
padding:4px;
line-height:1.8em;
}

.pinglist p {
text-align:left;
padding:8px 10px;
}

#commentlist li img {
padding:0;
border:0;
}

#commentlist li img.gravatar {
float:right;
margin:2px;
border:2px solid #f1f1f1;
}

<?php if(get_option('unnamed_ajaxcommenting') == 1) { ?> 
#error {
margin:2px;
padding:2px;
text-align:center;
color:#FF0000;
background:#FFFF99;
}

#commentload {
padding-top:3px;
float:right;
vertical-align:middle;
}
<?php } ?>
/* Images */
p img {
border:0;
max-width:100%;
padding:2px;
}

img.center,img[align="center"] {
display:block;
margin:auto;
}

img.alignright,img[align="right"] {
float:right;
display:inline;
margin:0 0 2px 7px;
padding:2px;
}

img.alignleft,img[align="left"] {
float:left;
display:inline;
margin:0 7px 2px 0;
padding:2px;
}

img.wp-smiley {
border:0;
}

.feedlink img {
float:right;
height:12px;
width:12px;
border:0;
margin:-19px 0 0;
}

/* Text align */
.center {
text-align:center;
}

.alignleft {
text-align:left;
}

.item,.alignright {
text-align:right;
}

/* Float */
div.floatright {
float:right;
}

div.floatleft {
float:left;
}

/* Classes */
.toggle-button {
float:right;
color:#6BA4DC;
background:none;
margin-right:10px;
}

.navigation {
display:block;
font-size:.9em;
text-align:center;
padding:15px 0;
}

.alert {
width:90%;
background:#FFFF99;
border-left:4px solid #FFD324;
text-align:center;
margin:10px 0;
padding:5px 10px 5px 0;
}

.metacmt {
background:url(<?php bloginfo('template_directory'); ?>/images/comment.png) left center no-repeat;
padding-left:18px;
}

.metaedit {
background:url(<?php bloginfo('template_directory'); ?>/images/comment_edit.png) left center no-repeat;
padding-left:18px;
}

.metapost {
background:url(<?php bloginfo('template_directory'); ?>/images/tag_blue.png) left center no-repeat;
padding-left:18px;
}

.clear {
clear:both;
}